# -*- coding: utf-8 -*-
import sys, os, time, nltk, numpy;
from nltk.tag.hmm import *
'''
Created on 10.05.2010
Süntaksianalüsaatori kursus
http://lepo.it.da.ut.ee/~kaili/Loengud/Analysaator10/
##
NLTK toolkit
Raamat: http://www.nltk.org/book
HOWTO: http://nltk.googlecode.com/svn/trunk/doc/howto/index.html 
##
Eesmärk: katsetada HMM taggerit Orwelli teksti peal
Eeldab, et ta saab ette kaks korpusefaili, train.est ja test.est, mis on genereeritud generateTrainAndTest.py skriptiga
#
KASUTAMINE: "NLTKTagger.py korpuse_kaust"
NÄIDE: "NLTKTagger.py corpora/"
(corpora/ all peavad olema failid "test.est" ja "train.est")
##
@author: Harri Kirik
@contact: harri35@gmail.com
'''

TRAIN_FILE_NAME = "train.est";

TEST_FILE_NAME = "test.est";

#############
#ABIMEETODID#
#############

#Abimeetod ajakoodidega logiteadete jaoks
def print2(line):
    "For timetags"
    print time.strftime("[%H:%M:%S] ", time.localtime()) + line

#Abimeetod programmi lõpetamiseks   
def quit():
    print2("Töö lõpp.");
    sys.exit()   

#Abimeetod andmete sisselugemiseks ja sõnade ning tag'ide eraldi hulkadesse panemiseks
def readDataIn(corpora):
    #Kohatud POS tagide hulk
    tagSet = set();
    #Kohatud sümolite kulk
    symbolSet = set();
    #Modifitseetirud laused
    cleanedSentences = list();
    #Sisseloetud lausete hulk
    lineCount = 0;
    #Iga lause jaoks
    for sentence in corpora:
        lineCount += 1;
        #Iga sõna (vektori jaoks)
        for i in range(len(sentence)):
            word, tag = sentence[i];
            #Anname hoiatuse, kui eeltöötluses on midagi valesti läinud ja vektor pole korrektne
            if(word == "" or word == None):
                print "|-> Hoitatus! Tühi sõna real " + str(lineCount) + "!";
            #Anname hoiatuse, kui eeltöötluses on midagi valesti läinud ja vektor pole korrektne
            if(tag == "" or tag == None):
                print "|-> Hoiatus! Tühi tag real " + str(lineCount) + "!";
            #lowercase'ime sõnad
            word = word.lower();
            #Lisame listidesse (HMM'i jaoks vajalik)
            symbolSet.add(word);    
            tagSet.add(tag);
            #Jätame modifitseeritud sõna ja tagi meelde uuesti
            sentence[i] = (word, tag);
        #Lisame modifitseeritud lause lausete hulka
        cleanedSentences.append(sentence);
    print "|-> Leidsin " + str(lineCount) + " lauset."
    return cleanedSentences, list(tagSet), list(symbolSet);

##############
#PÕHIPROGRAMM#
##############

print2("NLTK HMM Tagger.");
#Kas vajalikud sisendandmed on antud?
if(len(sys.argv) < 2):
    print "\nKasutamine: " + sys.argv[0] + " korpuse_kaust\n"
    print "(Eeldab, et korpuse kaustas on failid train.est ja test.est)";
    quit();

#Seame paika muutujad; vaatame, kas kaust eksisteerib
if(os.path.exists(sys.argv[1])):
    corporaFolder = sys.argv[1];
    print "|-> Otsin faile train.est ja test.est kaustast: " + corporaFolder;
else:
    print "|-> Viga, kaust " + sys.argv[1] + " ei eksisteeri!"
    quit();

##Märgendatud teksti lugemiseks vajalik lugeja
#http://docs.huihoo.com/nltk/0.9.5/api/nltk.corpus.reader.tagged.TaggedCorpusReader-class.html
taggedReader = nltk.corpus.reader.tagged.TaggedCorpusReader(corporaFolder, '[' + TRAIN_FILE_NAME + '|' + TEST_FILE_NAME + ']');


try:
    #treeningkorpus
    corporaTrain = taggedReader.tagged_sents(TRAIN_FILE_NAME);
    #testimiskorpus
    corporaTest = taggedReader.tagged_sents(TEST_FILE_NAME);
except IOError: 
    print "VIGA! Failide "+TRAIN_FILE_NAME+" ja "+TEST_FILE_NAME+" avamine kaustast "+corporaFolder+" ebaõnnestus!";
    quit();
#Katsetame unigramm taggerit
##
##
#print2("Unigramm tagger alustab ..");
#unigram_tagger = nltk.UnigramTagger(corporaTrain[100:])
#print 'Unigram Accuracy: %4.1f%%' % (100.0 * unigram_tagger.evaluate(corporaTest[:100]))
#print2("Unigramm tagger lõpetas.");
##

#HMM tagger
## 
#hmm.py moodulis demo_pos
##Eeltöötlus
print2("Loen sisse ja analüüsin treeninghulka (" + TRAIN_FILE_NAME + ") ..");
cleanedSentences, tagList, symbolList = readDataIn(corporaTrain);
print2("Lugemine lõpetatud.");

#Hmm tageri treenimine
print2("Treenin HMM POS märgendajat ..");
trainer = HiddenMarkovModelTrainer(tagList, symbolList);
hmm = trainer.train_supervised(cleanedSentences, estimator=lambda fd, bins: LidstoneProbDist(fd, 0.1, bins));
print2("Treenimine lõpetatud.");

#Hmm taggeri hindamine    
#Teeme test seti jaoks ka eeltöötluse ära
print2("Loen sisse ja analüüsin testihulka (" + TEST_FILE_NAME + ") ..");
cleanedSentencesTest, tagListTest, symbolListTest = readDataIn(corporaTest);
print2("Hindan HMM POS märgendajat ..");
#Hindamine demo test meetodiga (lisa ", verbose=True" kui tahad väga põhjalikku infot)
#hmm.test(cleanedSentencesTest)
#Hindamine üldise liidesega (tagastab vähem infot)
print '|-> HMM täpsus (accuracy): %4.1f%%' % (100.0 * hmm.evaluate(cleanedSentencesTest));
print2("Hindamine lõpetatud.");

#Programmi töö lõpp
print2("Töö lõpp.");
