# -*- coding: utf-8 -*-
import sys, os, time, random;
'''
Created on 10.05.2010
Süntaksianalüsaatori kursus
http://lepo.it.da.ut.ee/~kaili/Loengud/Analysaator10/
##
Eeltöötlusskript
Tahab ette saada märgendatud korpust
Kontrollib etteantud korpust (kas on korralikult tagitud) ja jagab train.est'iks ja test.est'iks.
##
KASUTAMINE: "generateTrainAndTest.py märgendatud_korpuse_fail test_korpuse_suurus_ridades uus_train_korpus uus_test_korpus"
NÄIDE: "generateTrainAndTest.py corpora\tagged.est 500 corpora\train.est corpora\test.est"
##
@author: Harri Kirik
@contact: harri35@gmail.com
'''
#############
#ABIMEETODID#
#############

#Abimeetod ajakoodidega logiteadete jaoks
def print2(line):
    "For timetags"
    print time.strftime("[%H:%M:%S] ", time.localtime()) + line;

#Abimeetod programmi lõpetamiseks    
def quit():
    print2("Töö lõpp.");
    sys.exit();   

#Abimeetod hindamiseks, kas ette antud lauses on kõik tag'id korrektsed.
#Kui kõik korrektsed, siis meetod tagastab False - vigu polnud
#Kui pole korrektsed, siis tagastab stringi lühikese veateatega
def taggingNotCorrect(line):
    vectors=line.split(" ");
    #print vectors;
    for v in vectors:
        #Kui vektorit pole
        if(v=="" or v==None):
            return "[Vektor tühi]";
        vectorSplit=v.split("/");
        #Kui vektori esimene komponent on tühi "/RR"
        if(vectorSplit[0]=="" or vectorSplit[0]==None):
            return "[Vektori esimene komponent tühi]";
        #Kui vektori teine komponent on tühi
        if(len(vectorSplit)>1 and (vectorSplit[1]=="" or vectorSplit[1]==None)):
            return "[Vektori teine komponent tühi]";
        #Kui vektor on pikem kui kaks (kaks vektorit on kokku sattunud vms)
        if(len(vectorSplit)>2):
            return "[Vektoris rohkem kui kaks komponenti]";
        #Kui vektor pole reavahetus ja on lühem kui kaks komponenti
        if(v!="\n" and len(vectorSplit)<2):
            return "[Ainult üks komponent vektoris]";
    return False;


##############
#PÕHIPROGRAMM#
##############

print2("Kopruse jagaja/kontrollija alustab");
#Kas vajalikud sisendandmed on antud?
if(len(sys.argv)<5):
    print "\nKasutamine: "+sys.argv[0]+" märgendatud_korpuse_fail test_korpuse_suurus_ridades uus_train_korpus uus_test_korpus\n"
    quit();

#Seame paika muutujad
testCorporaLen=int(sys.argv[2]);
#Avame failid lugemiseks ja kirjutamiseks
inputCorporaFile = open(sys.argv[1], 'r');
trainCorporaFile = open(sys.argv[3], 'w');
testCorporaFile = open(sys.argv[4], 'w');
#loeme sisendkorpuse listi
#Kokku korrektseid ridu
lineCount=0;
#Kokku läbivaadatud ridu
lineNR=0;
#Sisseloetud korrektsed laused
sentenceList=list()
print2("Alustan lausete sisselugemist ..");
for line in inputCorporaFile:
    lineNR+=1;
    #Kas tegemist korrektse lausega
    checkResultNegative=taggingNotCorrect(line);
    if(checkResultNegative):
        print "|-> Eemaldan vigase lause " + str(lineNR)+ " " + checkResultNegative;
        continue;
    #Kui korras lause, siis lisa
    lineCount+=1;
    sentenceList.append(line);
print2("Sisselugemine lõpetatud.");
if (lineCount>testCorporaLen):
    print "|-> Korpusest leiti " + str(lineCount) + " korralikku lauset," + " neist " + str(testCorporaLen) + " tõstetakse test korpusesse";
    print "|-> (Eemaldati " + str(lineNR-lineCount) + " vigast lauset)";
else:
    print "|-> VIGA! Etteantud test korpuse suurus liiga suur, sisendkorpuses on ainult " + str(lineCount) + " korrektset lauset.";
    quit();


#Test korpuse lausete list
testSentenceList=list();
#Tõstame juhuslikkuse alusel testCorporaLen laustet teise listi
while len(testSentenceList)<testCorporaLen:
    #Suvaline index listist
    rndPos=random.randint(0, (len(sentenceList)-1));
    #Lisame lause test korpusesse ja eemaldame dev korpusest
    testSentenceList.append(sentenceList.pop(rndPos));

print2("Kirjutan laused korpustesse ..");
#Kirjutame listides olevad laused train ..
print "|-> Kirjutan " + str(len(sentenceList)) + " lauset train korpusesse.";
for sentence in sentenceList:
    trainCorporaFile.write(sentence);

# .. ja test korpustesse
print "|-> Kirjutan " + str(len(testSentenceList)) + " lauset train korpusesse.";
for sentence in testSentenceList:
    testCorporaFile.write(sentence);

print2("Kirjutamine lõpetatud");
#Sulgeme failid
inputCorporaFile.close();
trainCorporaFile.close();
testCorporaFile.close();

#Töö lõpp
quit();